function JSocket() {
   this.initialize.apply(this, arguments);
}

JSocket.VERSION = '1.0';
JSocket.init = function(src, onLoad) {
   JSocket.onLoad = onLoad;
   JSocket.flashapi = $('<div></div>').appendTo('body').flashembed({
      id: 'TCP',
      name: 'socket',
      src: src,
      allowfullscreen: false,
      width: '1px',
      height: '1px',
      wmode: 'transparent',
      bgcolor: '#1fffff',
      allowScriptAccess: 'always'
   }).getApi();
};

JSocket.loaded = function() {
   if(JSocket.onLoad)
      JSocket.onLoad();
}

JSocket.handlers = new Array();
JSocket.defaultHandlers = {
    connectHandler: function () {},
    dataHandler: function () {},
    closeHandler: function () {},
    errorHandler: function () {}
};
JSocket.connectHandler = function(socid) {
    JSocket.handlers[socid].connectHandler();
};
JSocket.dataHandler = function(socid, data) {
    JSocket.handlers[socid].dataHandler(data);
};
JSocket.closeHandler = function(socid) {
    JSocket.handlers[socid].closeHandler();
};
JSocket.errorHandler = function(socid, str) {
    JSocket.handlers[socid].errorHandler(str);
};
JSocket.prototype = {
   initialize: function(handlers) {
      this.socid = JSocket.flashapi.newsocket();
      JSocket.handlers[this.socid] = $.extend(JSocket.defaultHandlers.prototype, handlers);
   },
   connect: function(host, port) {
      JSocket.flashapi.connect(this.socid, host, port);
   },
   write: function(data) {
      JSocket.flashapi.write(this.socid, data);
   },
   writeFlush: function(data) {
      JSocket.flashapi.writeFlush(this.socid, data);
   },
   close: function() {
      JSocket.flashapi.close(this.socid);
   },
   flush: function() {
      JSocket.flashapi.flush(this.socid);
   }
};
